ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	NAHOON_HT.F

c	Temperature and density fixed.
c	There is no file with the differential equations explicitly
c	written but some loops. For that an additional species which is 
c	blank is added.
c
c
c	VODE integretor
c	Wakelam V. Mai. 2006
c
c	VW Sept 2006 added the self-shielding of H2 and CO using the solutions
c	by Lee et al. (1996)	
C	VW Sept 2006 the reactions of H2 formation have been modified from the classic
c	way to take into account the numerical imprecision of the model
c
c       Modification for the High Temperature by N. Harada, Sep. 2010
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	
	PROGRAM NAHOON_HT

	IMPLICIT NONE

	INTEGER NS,NRTOT,NTIME,ITYPE,INUM,IPROD,NELEM,NS2,
     &		ITEST,ITEST2,ELEMENT,I,J,ISP,JSTEP,L,NPLOT,JJ,IH,
     &		IGRAIN0,IGRAINN,IH2FORM,POLNUM
	PARAMETER (NS=461+1,NRTOT=5407,NTIME=124,NELEM=13+1,NPLOT=NS-1)
	PARAMETER (POLNUM=165)
	DOUBLE PRECISION SN,Y,AB,PLOTAB,TPLOT,TD,TIMERES,NHTOT,TYR,
     &		TIMESELEC,XK1,XK2,YGRAIN,XCO,XH2,A,B,C,RANDOM1,UNC,ZETA,
     &		GTODN,TAU,NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,SNGRAIN,
     &          MOMENT,POLA,STCOEFF,RCEFF
	CHARACTER*8 SPEC,REACTANT*8,SPEC_DATA*8
     	DIMENSION SN(NS),Y(NS),AB(NS),PLOTAB(NTIME,NPLOT),A(NRTOT),B(NRTOT),C(NRTOT),	
     &		TIMERES(NTIME),SPEC(NS),ITEST(6),ELEMENT(NELEM,NS),REACTANT(3,NRTOT),
     &		ITYPE(NRTOT),RANDOM1(NRTOT),UNC(NRTOT),NCO(52),NH2_2(105),T_H2_2(105),
     &            T_CO(52),NH2_1(43),T_H2_1(43),AV(43),T_AV(43)	
        DIMENSION MOMENT(POLNUM),POLA(POLNUM),SPEC_DATA(POLNUM)	  
	CHARACTER AA*78,RANDMODE

	INTEGER REACT(NRTOT,7),NRBIS
	DOUBLE PRECISION K(NRTOT)
	COMMON/EQUA/K,REACT,NRBIS
	
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c 	Variable declaration FOR THE DLSODE SUBROUTINE
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	EXTERNAL F, JAC
	INTEGER NEQ, ITOL, ITASK, ISTATE, IOPT, LRW, IWORK, LIW, JEX, MF
	DOUBLE PRECISION T, TOUT, RTOL, ATOL, RWORK
	PARAMETER (NEQ=NS, LIW=20+NEQ, LRW=22 +  9*NEQ + NEQ**2)
	DIMENSION IWORK(LIW), RWORK(LRW)

	DATA ITOL, ITASK, ISTATE, IOPT, MF, RTOL, ATOL
     &		/1, 3, 1, 1, 22, 1.D-4, 1.D-40/

	NRBIS=NRTOT
	NS2=NS
	IWORK(6)=10000
	RWORK(6)=3.154E+15
	IWORK(5)=5
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Files declaration
c	Here, we open the files we have to read (list of species + inital 
c	abundances + reactions + CO and H2 self-shielding factors + random numbers for 
c	the uncertainty calculation) and we define the output files:
c	- Kout.dat contain the values of the rate coefficients
c	- plot.dat the abundances as a function of time
c	- verif.dat contains some balance verifications and the 
c	rates of formation and destruction for each species at 
c	specific times
c	- output.dat is the chemical composition at one time (by default 1e8yr)
c	in the same format as cond_initial.dat
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	OPEN (UNIT=1,FILE='osu_09_2008_ht',STATUS='OLD')
	OPEN (UNIT=2,FILE='cond_initial_ht_fmt.dat',STATUS='OLD')
	OPEN (UNIT=3,FILE='input_parameter.dat',STATUS='OLD')
	OPEN (UNIT=4,FILE='timeres.dat',STATUS='OLD')
	OPEN (UNIT=5,FILE='random.dat',STATUS='OLD')
	OPEN (UNIT=7,FILE='Self_Shielding_data',STATUS='OLD')
	OPEN (UNIT=8,FILE='pol_data',STATUS='OLD')

	OPEN (UNIT=9,FILE='Kout.dat',STATUS='UNKNOWN')
	OPEN (UNIT=10,FILE='plot.dat',STATUS='UNKNOWN')
	OPEN (UNIT=11,FILE='verif.dat',STATUS='UNKNOWN') 
	OPEN (UNIT=12,FILE='output.dat',STATUS='UNKNOWN') 

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC 
C	read data files 
c
C	AB is the abundance species with respect to total 
C	SN is in number density (cm-3) 

c	First put some numbers to zero
	DO I=1,NS
		SN(I)=0.D0
		Y(I)=0.D0
		AB(I)=0.D0
		DO ISP=1,NELEM
			ELEMENT(ISP,I)=0
		ENDDO		
	ENDDO

	DO I=1,NRTOT
	    K(I) = 0.0D0
	ENDDO

	T=0.D0
     	JSTEP=0

C	read output times
	READ(4,*) TIMERES

C	reacd initial conditions (abundance /H) 

	DO I=1,10
		READ (2,*) AA
	ENDDO		
	DO I=1,NS-1
		READ (2,1) SPEC(I),(ELEMENT(ISP,I),ISP=1,NELEM),AB(I)
	ENDDO		
1	FORMAT(5X,A8,1X,14(I3),2X,D14.8)	
	
C	for the additional blank species 		 	
 	SPEC(NS)='        '
 	AB(NS)=0.D0
	SN(NS)=0.D0
	
C	read the parameters 
	DO I=1,9
		READ (3,14) AA
	ENDDO	
14	FORMAT(A78)	
	READ(3,2) RANDMODE
2	FORMAT(A1)		
	READ(3,3) NHTOT
	READ(3,3) TD
	READ(3,3) TIMESELEC
3	FORMAT(D9.3)
	
C	if we are in the uncertainty mode, RANDMODE is Y 
c	and the temperature and density are read in the random.dat file
	IF (RANDMODE.EQ.'Y') THEN 	
		READ(5,*) NHTOT
		READ(5,*) TD
	ENDIF	
		
C	compute the species density from the initial abundances 
c	SNGRAIN is the total abundance of grains
	DO I=1,NS-1
		SN(I)=AB(I)*NHTOT	
		PLOTAB(1,I)=SN(I) 
		IF (SPEC(I).EQ.'H       ') IH=I
		IF (SPEC(I).EQ.'GRAIN0  ') IGRAIN0=I
		IF (SPEC(I).EQ.'GRAIN-  ') IGRAINN=I
		IF (SPEC(I).EQ.'CO      ') XCO=AB(I)
		IF (SPEC(I).EQ.'H2      ') XH2=AB(I)	
	ENDDO		
	SNGRAIN=SN(IGRAIN0)+SN(IGRAINN)
	
C	read the chemical database
	CALL READ_REACT(IH2FORM,NS2,RANDMODE,ELEMENT,NELEM,A,B,C,REACTANT,SPEC,ITYPE,
     &			RANDOM1,UNC,ZETA,GTODN,TAU,NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,
     &			NH2_2,T_H2_2,MOMENT,POLA,SPEC_DATA)


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	compute the rate coefficients
c
	
	CALL RATE_COEFF(A,B,C,GTODN,TAU,ZETA,NHTOT,NS2,TD,XH2,XCO,
     &			NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,RANDOM1,
     &	     		UNC,JSTEP,ITYPE,RANDMODE,REACTANT,SNGRAIN,
     &                  MOMENT,POLA,SPEC_DATA,STCOEFF,RCEFF)

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	compte the chemical evolution
c
     	
C	definition of the times at which the rates of formation/destruction
c	are writen in verif.dat
	ITEST(1) = 2
	ITEST(2) = 11 
	ITEST(3) = 34
	ITEST(4) = 56
	ITEST(5) = 79
	ITEST(6) = 101
	ITEST2=1

C	because of the definition of the rate coefficient of H2 formation 
c	we have to devide the rate coefficient of this reaction by N(H). 
c 	Here, we first save the value of the rate
	XK1=K(IH2FORM)
		
C	starting the loop 

	WRITE (*,*) 'It is computing.... wait !'

	DO JSTEP=2,NTIME

C	TOUT is the output time of the dlsode subroutine and is set to be the 
c	time in sec from the table timeres 
c	TYR is the time in year writen in the output file
	TOUT=TIMERES(JSTEP)*3.154D7
	TYR=TIMERES(JSTEP)
	
C	we transfer the values of the species densities into the 
c	variable Y used by dlsode	
	DO ISP=1,NS
		Y(ISP) = SN(ISP)
 	ENDDO

C	because of the definition of the rate coefficient of H2 formation
c	we divide it by N(H) 

	IF (Y(IH).NE.0.D0) K(IH2FORM)=XK1/Y(IH)

C	no variation for the blank species
	Y(NS)=1.D0

C	we call the subroutine to solve the differential equations 
	CALL DLSODE (F, NEQ, Y, T, TOUT, ITOL, RTOL, ATOL, ITASK,
     &                ISTATE, IOPT, RWORK, LRW, IWORK, LIW, JAC, MF)
	
	
C	put the densities as abundances compared to total H 
	DO ISP=1,NS
		IF (SN(ISP).LT.0.D0) SN(ISP)=0.D0
		SN(ISP) = Y(ISP)
		AB(ISP) = SN(ISP)/NHTOT
		IF (SPEC(ISP).EQ.'CO      ') XCO=AB(ISP)
		IF (SPEC(ISP).EQ.'H2      ') XH2=AB(ISP)	
	ENDDO
 
C	writing the abundances in the PLOTAB for the plot.dat file 
	DO ISP=1,NS-1
    		PLOTAB(JSTEP,ISP)=SN(ISP)
	ENDDO

C	write the verif.dat file, the output.dat file 
	IF (JSTEP.EQ.ITEST(ITEST2)) THEN 
		WRITE(*,*) 'T(YR)=',TYR
		WRITE(11,*) 'T(YR)=',TYR
		
		CALL CHECKING(NS2,ELEMENT,NELEM,SN,IGRAIN0,IGRAINN)
		CALL COMP_RATES(SN,SPEC,NEQ)
		ITEST2=ITEST2+1
	ENDIF	

	IF (TYR.EQ.TIMESELEC) THEN
	WRITE(12,4) 'ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc'
	WRITE(12,4) 'c output.dat				                                   '			
	WRITE(12,4) 'c	May 2006 Wakelam Valentine			                           '			
	WRITE(12,4) 'c	output file of the chemical composition		                           '			
	WRITE(12,4) 'c	Abundances compared to H			                           '	
	WRITE(12,4) 'c	Columns indicate:				                           '
	WRITE(12,4) 'c	number	species	 charge  element (H, He, C, O, S, Grain) Abundance          '
	WRITE(12,4) 'c	Please respect the format				                    '
	WRITE(12,4) 'cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc'
	WRITE(12,5) TIMESELEC,'     +-  H  He C  O  S  G		                                    '				
4	FORMAT(A78)
5	FORMAT(D8.2,A70)
		DO I=1,NS-1
		WRITE(12,6) I,SPEC(I),(ELEMENT(ISP,I),ISP=1,NELEM),AB(I)                           
		ENDDO		
	ENDIF                           
6	FORMAT (I4,1X,A8,1X,14(I3),2X,D14.8)
	
c	re-compute the rate coefficients. 
c	This is useful if one wants the temperature to evolve and 
c	to compute the H2 and CO self-shielding which depend on the H2 and CO abundances
	CALL RATE_COEFF(A,B,C,GTODN,TAU,ZETA,NHTOT,NS2,TD,XH2,XCO,
     &			NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,RANDOM1,
     &	     		UNC,JSTEP,ITYPE,RANDMODE,REACTANT,SNGRAIN,
     &                  MOMENT, POLA,SPEC_DATA,STCOEFF,RCEFF)

	ENDDO
 
C	end of big loop

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C	write the plot.dat file for all times 
	
	WRITE (10,7) 'Gas temperature (K)', TD
	WRITE (10,7) 'Total H density (cm-3)',NHTOT 
7	FORMAT(A23,E10.2)
	WRITE(10,8) TIMERES
8	FORMAT(8X,124(2X,D14.8))	
	DO ISP=1,NS-1
		WRITE(10,9) SPEC(ISP),(PLOTAB(I,ISP),I=1,NTIME)
	ENDDO
9	FORMAT(A8,124(2X,D14.8))		

	 STOP 
	 END 
	 
C	end of main program
cccccccccccccccccccccccccccccccccccccccccccccccccccccc

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C	this subroutine reads the reactions in the database 

	SUBROUTINE READ_REACT(IH2FORM,NS2,RANDMODE,ELEMENT,NELEM,A,B,C,REACTANT,
     &			SPEC,ITYPE,RANDOM1,UNC,ZETA,GTODN,TAU,NCO,T_CO,NH2_1,
     &			T_H2_1,AV,T_AV,NH2_2,T_H2_2,MOMENT,POLA,SPEC_DATA)

	IMPLICIT NONE

	DOUBLE PRECISION A,B,C,RANDOM1,UNC,ZETA,DTOGM,RD,RHOD,TAU,
     &		NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,GTODN,SUM1,SUM2,
     &          AMH,BOLTZ,PI,MOLE,MOMENT, POLA
	INTEGER INUM,ITYPE,NRBIS2,ELEMENT,NELEM,IR1,IR2,IR3,IH2FORM,
     &		DES1,DES2,IPROD1,IPROD2,IPROD3,IPROD4,L,NS2,I,J,POLNUM

	PARAMETER (NRBIS2=5407,POLNUM=165)
	CHARACTER REACTANT*8,PRODUIT*8,SPEC*8,AA*78,RANDMODE,SPEC_DATA*8
	DIMENSION ITYPE(NRBIS2),A(NRBIS2),B(NRBIS2),C(NRBIS2), 
     &		  INUM(NRBIS2),RANDOM1(NRBIS2),UNC(NRBIS2),NCO(52),
     &            T_CO(52),NH2_1(43),T_H2_1(43),AV(43),T_AV(43),
     &		  NH2_2(105),T_H2_2(105),ELEMENT(NELEM,NS2),REACTANT(3,NRBIS2),
     &		  PRODUIT(4,NRBIS2),SPEC(NS2)
	DIMENSION MOMENT(POLNUM), POLA(POLNUM), SPEC_DATA(POLNUM)
     
	INTEGER REACT(NRBIS2,7),NRBIS
	DOUBLE PRECISION K(NRBIS2)
	COMMON/EQUA/K,REACT,NRBIS

	DATA AMH,BOLTZ,PI,MOLE
     &     /1.66043D-24, 1.38054D-16, 3.14159265, 6.023D23/

C	reading the parameters for the uncertainties if we are in the uncertainty mode 
	IF (RANDMODE.EQ.'Y') THEN
		READ(5,*) RANDOM1
		READ(5,*) UNC
	ENDIF
	
C	reading other parameters 
 	READ(3,10) ZETA
	READ(3,10) DTOGM
	READ(3,10) RD
	READ(3,10) RHOD
	READ(3,10) TAU

10	FORMAT (D9.3)

C	reading the CO and H2 self-shielding parameters 
	READ(7,14) AA
	DO J=1,43
		READ(7,12) NCO(J),T_CO(J),NH2_1(J),T_H2_1(J),AV(J),T_AV(J)
	ENDDO
	DO J=44,52
		READ(7,13) NCO(J),T_CO(J)
	ENDDO	
	
	READ(7,15) AA
14	FORMAT(A52)
15	FORMAT(A17)

	DO J=1,105
		READ(7,13) NH2_2(J),T_H2_2(J)
	ENDDO	
12	FORMAT (6(E9.3,3X))
13	FORMAT (E9.3,3X,E9.3)

c	reading the chemical database
	DO J=1,NRBIS2
		READ (1,11) REACTANT(1,J),REACTANT(2,J),REACTANT(3,J),PRODUIT(1,J),
     &  		PRODUIT(2,J),PRODUIT(3,J),PRODUIT(4,J),A(J),B(J),C(J), 
     &          	   ITYPE(J),INUM(J)
	
c	find the reaction of H2 formation
		IF ((REACTANT(1,J).EQ.'H       ').AND.(REACTANT(2,J).EQ.'H       ').
     &			AND.(REACTANT(3,J).EQ.('        ')).AND. (PRODUIT(1,J).EQ.
     &			'H2      ')) IH2FORM=J

	ENDDO
11	FORMAT (7(A8),8X,3(E9.2),I2,14X,I4) 


C	GTODN is the ratio between the density of gas and the density of grains 
	GTODN=(4.d0*PI*RHOD*RD*RD*RD)/(3.d0*DTOGM*AMH)

c	construct the table REACT which is used to construct the differential equations
 	DO I=1,NRBIS2
		DO J=1,NS2
		DO L=1,3
			IF (REACTANT(L,I).EQ.SPEC(J)) REACT(I,L)=J
		ENDDO
		DO L=1,4
			IF (PRODUIT(L,I).EQ.SPEC(J)) REACT(I,L+3)=J
		ENDDO		
		ENDDO
	ENDDO	

C	check the balance of the reactions (elements and charges) 
	DO I=1,NRBIS2
		IR1=REACT(I,1)
		IR2=REACT(I,2)
		IR3=REACT(I,3)
		IPROD1=REACT(I,4)
		IPROD2=REACT(I,5)
		IPROD3=REACT(I,6)
		IPROD4=REACT(I,7)
		DO J=1,NELEM
			SUM1=ELEMENT(J,IR1)+ELEMENT(J,IR2)+ELEMENT(J,IR3)
			SUM2=ELEMENT(J,IPROD1)+ELEMENT(J,IPROD2)+ELEMENT(J,IPROD3)+
     &				ELEMENT(J,IPROD4)
     			IF (SUM1.NE.SUM2) 
     &			WRITE(*,*) 'BALANCE PROBLEM AT THE REACTION',I
		ENDDO
	ENDDO
        DO J=1,POLNUM
              READ (8,16) SPEC_DATA(J),POLA(J),MOMENT(J)
        ENDDO      
16     FORMAT(A8,F7.3,7X,F7.3) 				

	RETURN
	END 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C	this subroutine computes the rate coefficients of the reactions 
C	
C	the formula to compute the rates depends on the type of reaction 
C	We have 12 kinds of reactions: 
C	
C
c 	ITYPE 0 interactions with grains 
C 	ITYPE 1 cosmic rays and photodis induced reactions
C 	ITYPE 2 positive ion-neutral reactions
c	ITYPE 3 negative ions-neutral reactions
C 	ITYPE 4 ion-neutral Radiative association
C 	ITYPE 5 negative-neutral association Electronic recombination
C 	ITYPE 6 
C 	ITYPE 7 neutral-neutral reactions
C 	ITYPE 8 neutral-neutral radiative association    
C 	ITYPE 9 electronic dissociative recombination 
c	ITYPE 10 electronic recombination 
c	ITYPE 11 
c	ITYPE 12 electron attachment
c	ITYPE 13 photodissociations
	 	
C	if you add a new kind of reaction, you have to add here the way 
c	to compute the rate coefficient 

 
	SUBROUTINE RATE_COEFF(A,B,C,GTODN,TAU,ZETA,NHTOT,NS2,TD,XH2,XCO,
     &			NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,RANDOM1,
     &	     		UNC,JSTEP,ITYPE,RANDMODE,REACTANT,SNGRAIN,
     &                   MOMENT,POLA, SPEC_DATA,STCOEFF,RCEFF)  
 	
	IMPLICIT NONE
	
	DOUBLE PRECISION MOLE,GTODN,
     &  	PI,AMH,BOLTZ,TT,TD,ZETA,NHTOT,A,B,C,TAU,RANDOM1,UNC,
     &		NCO,T_CO,NH2_1,T_H2_1,AV,T_AV,NH2_2,T_H2_2,SNGRAIN,
     &		NCOLLH2,XH2,XCO,TETA,NCOLLCO,TETA1,TETA2,TETA3,
     &          MOMENT, POLA,X,STCOEFF,RCEFF
     	INTEGER ITYPE,INUM,NRBIS2,NS2,L,JSTEP,I,J,ISP,POLNUM
	PARAMETER (NRBIS2=5407,POLNUM=165)
	CHARACTER REACTANT*8,RANDMODE,AA*78,SPEC_DATA*8
	DIMENSION ITYPE(NRBIS2),A(NRBIS2),B(NRBIS2),C(NRBIS2), 
     &		  REACTANT(3,NRBIS2),RANDOM1(NRBIS2),UNC(NRBIS2),
     &		NCO(52),T_CO(52),NH2_1(43),T_H2_1(43),AV(43),T_AV(43),
     &		NH2_2(105),T_H2_2(105), MOMENT(POLNUM), POLA(POLNUM),
     &          SPEC_DATA(POLNUM)


	INTEGER REACT(NRBIS2,7),NRBIS
	DOUBLE PRECISION K(NRBIS2)
	COMMON/EQUA/K,REACT,NRBIS

	DATA AMH,BOLTZ,PI,MOLE
     &     /1.66043D-24, 1.38054D-16, 3.14159265, 6.023D23/

	TT=TD/300.D0

c       recombination efficiencies
	IF (TD.LT.30.) THEN
	   RCEFF=1.0
	ELSE IF (TD.LT.100.) THEN
	   RCEFF=1.0-(0.8/70.)*(TD-30.)
	ELSE
	   RCEFF=0.2
	ENDIF

c	STCOEFF=1.0

c       sticking coefficient for Silicates
	STCOEFF=1/(1+0.04*TD**0.5+2.0e-3*TD+8.0e-6*TD**2.0)

c	start computing the rate coefficients depending on the type of reaction 
	DO J=1,NRBIS2

	   IF (ITYPE(J).EQ.0) THEN
	   	K(J)=A(J)*(TT**B(J))*GTODN 
	   	IF ((REACTANT(1,J).EQ.'H       ').AND.(REACTANT(2,J).EQ.'H       '))		
     &			K(J)=A(J)*(TT**B(J))*NHTOT*STCOEFF*RCEFF
     	   ENDIF

	   IF (ITYPE(J).EQ.1) K(J)=A(J)*ZETA
	   
	   IF (ITYPE(J).EQ.13) THEN
		K(J)=A(J)*EXP(-C(J)*TAU)
		
C 	computation of the H2 and CO self-shielding by linear extrapolations
		IF (REACTANT(1,J).EQ.'H2      ') THEN
			NCOLLH2=(TAU/5.34D-22)*XH2
			TETA=1
			DO L=1,104
				IF ((NH2_2(L).LE.NCOLLH2).AND.(NH2_2(L+1).
     &				GE.NCOLLH2)) 
     &				TETA=T_H2_2(L)+(NCOLLH2-NH2_2(L))*
     &				(T_H2_2(L+1)-T_H2_2(L))/(NH2_2(L+1)-NH2_2(L))
			ENDDO
			
		    	K(J)=2.54D-11*TETA
			
			IF (NCOLLH2.GT.NH2_2(105)) K(J)=A(J)*EXP(-C(J)*TAU)	
		 ENDIF
	   	 IF (REACTANT(1,J).EQ.'CO      ') THEN
	   		NCOLLH2=(TAU/5.34D-22)*XH2
			NCOLLCO=(TAU/5.34D-22)*XCO
			TETA1=1
			TETA2=1
			TETA3=1
			DO L=1,51
				IF ((NCO(L).LE.NCOLLCO).AND.(NCO(L+1).GE.NCOLLCO)) 
     &				TETA2=T_CO(L)+(NCOLLCO-NCO(L))*(T_CO(L+1)-T_CO(L))
     &				/(NCO(L+1)-NCO(L))
			ENDDO
			DO L=1,42
				IF ((NH2_1(L).LE.NCOLLH2).AND.(NH2_1(L+1).GE.NCOLLH2)) 
     &				TETA1=T_H2_1(L)+(NCOLLH2-NH2_1(L))*(T_H2_1(L+1)-T_H2_1(L))
     &				/(NH2_1(L+1)-NH2_1(L))
				IF ((AV(L).LE.TAU).AND.(AV(L+1).GE.TAU)) 
     &				TETA3=T_AV(L)+(TAU-AV(L))*(T_AV(L+1)-T_AV(L))
     &				/(AV(L+1)-AV(L))
			ENDDO
		
	    		K(J)=1.03D-10*TETA1*TETA2*TETA3
			
			IF ((NCOLLH2.GT.NH2_1(43)).OR.(NCOLLCO.GT.NCO(52)).OR.(TAU.GT.AV(43)))
     &					K(J)=A(J)*EXP(-C(J)*TAU)		

	   	  ENDIF
	   ENDIF
	   	   
	   DO I=2,12
	  	 IF (ITYPE(J).EQ.I) K(J)=A(J)*(TT**B(J))*EXP(-C(J)/TD)
 	   ENDDO


	    IF (ITYPE(J).EQ.20) then
	       DO L=1,POLNUM 
		  IF (SPEC_DATA(L).EQ.REACTANT(2,J))  THEN

		     X=3.4744*MOMENT(L)*sqrt(300.D0)/sqrt(POLA(L)*TD)
		   

		     if (X.GE.2.D0) K(J)=(A(J)*(1.4520D-9*sqrt(POLA(L)/C(J))+ 
     &             6.7185D-8*MOMENT(L)/sqrt(C(J)*TD)))*EXP(-B(J)/TD)

		     if (X.LT.2.D0)	K(J)=(A(J)*(2.342D-9*sqrt(POLA(L)/C(J))+
     &             1.3629D-8*MOMENT(L)/sqrt(C(J)*TD)+
     &             8.0576D-7*MOMENT(L)**2/(TD*sqrt(POLA(L)*C(J)))))
     &             *EXP(-B(J)/TD)

                        ENDIF
                ENDDO
c		if (K(J).EQ.0.0) write(*,*) 'no dipl data for reaction ',J
	     ENDIF 
	     IF (ITYPE(J).EQ.41) THEN
		IF (TD.LT.300) THEN
		  K(J)=A(J)*(TT**B(J))*EXP(-C(J)/TD)
		ELSE 
		   K(J)=0.00e+00
		ENDIF
	     ENDIF
	     IF (ITYPE(J).EQ.42) THEN
		IF (TD.LT.300) THEN
		   K(J)=0.00e+00
		ELSE 
		   K(J)=A(J)*(TT**B(J))*EXP(-C(J)/TD)
		ENDIF
	     ENDIF

     
     
	ENDDO	
		
C	modification of the rates for the uncertainties 
	IF (RANDMODE.EQ.'Y') THEN
	DO J=1,NRBIS2 
		K(J)=10**(DLOG10(K(J))+0.5*DLOG10(UNC(J))*RANDOM1(J))
	ENDDO		
	ENDIF
	
C	remove the very small rate coefficients 
	DO J=1,NRBIS2 	
		IF (K(J).LT.1.D-50) K(J)=0.D-50
	ENDDO

C       writing the rate coefficients in the Kout.dat file 
	IF (JSTEP.EQ.0) THEN
		WRITE (9,*) 'Rate coefficients of the reactions'
		WRITE (9,*) 'Tk =    ',TD
		DO J=1,NRBIS2
	   		WRITE (9,*) J, K(J)
		ENDDO
	ENDIF
	
	RETURN
	END 

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	this subroutine contains the differential equations
c
	SUBROUTINE F (NEQ, T, Y, YDOT)
	
	IMPLICIT NONE
	
	INTEGER NEQ, NRBIS2
	PARAMETER (NRBIS2=5407)

	INTEGER IR1,IR2,IR3,DES1,DES2,IPROD1,IPROD2,IPROD3,IPROD4,I,J

	DOUBLE PRECISION Y, YDOT, UP, DOWN, RATE,T
	DIMENSION Y(NEQ), YDOT(NEQ), UP(NEQ), DOWN(NEQ)
	
	INTEGER REACT(NRBIS2,7),NRBIS
	DOUBLE PRECISION K(NRBIS2)
	COMMON/EQUA/K,REACT,NRBIS

	IF (NRBIS.NE.NRBIS2) WRITE(*,*) 'Wrong number of reactions in subroutine f'
	

	DO I=1,NEQ
		UP(I)=0.d0
		DOWN(I)=0.d0
	ENDDO 		


C	the differential equations are calcultaed in a loop here 
	DO I=1,NRBIS2
 
 		IR1=REACT(I,1)
		IR2=REACT(I,2)
		IR3=REACT(I,3)
		IPROD1=REACT(I,4)
		IPROD2=REACT(I,5)
		IPROD3=REACT(I,6)
		IPROD4=REACT(I,7)
		
		RATE=K(I)*Y(IR1)*Y(IR2)*Y(IR3)
		
		UP(IPROD1)=UP(IPROD1)+RATE
 		UP(IPROD2)=UP(IPROD2)+RATE
 		UP(IPROD3)=UP(IPROD3)+RATE
  		UP(IPROD4)=UP(IPROD4)+RATE

 		DOWN(IR1)=DOWN(IR1)+RATE
 		DOWN(IR2)=DOWN(IR2)+RATE
 		DOWN(IR3)=DOWN(IR3)+RATE

	ENDDO	

	DO I=1,NEQ-1
		YDOT(I)=UP(I)-DOWN(I)
	ENDDO
	
	YDOT(NEQ)=0.d0
		
	RETURN
	END
	
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	this subroutine computes the rates of formation and destruction 
C	for each species and put them in the increasing order 

	SUBROUTINE COMP_RATES (SN,SPEC,NEQ)
	
	IMPLICIT NONE	

	INTEGER J,NRBIS2,IR1,IR2,IR3,IPROD1,IPROD2,IPROD3,
     &	 	IPROD4,IY,M,I,NS2,NRBIS3,NEQ
	PARAMETER (NRBIS2=5407,NS2=461+1)
	DOUBLE PRECISION SN,FORMTOT,DESTOT,RATE,X,FORM,DEST
	DIMENSION SN(NS2),FORMTOT(NS2),DESTOT(NS2),FORM(NS2,NRBIS2),
     &		DEST(NS2,NRBIS2),IY(NRBIS2),X(NRBIS2)	
	CHARACTER*8 SPEC(NS2)
	
	INTEGER REACT(NRBIS2,7),NRBIS
	DOUBLE PRECISION K(NRBIS2)
	COMMON/EQUA/K,REACT,NRBIS
     	
	NRBIS3=NRBIS2
	IF (NS2.NE.NEQ)	WRITE (*,*) 'Wrong number of species in COMP_RATES' 
	
	DO J=1,NS2 
		FORMTOT(J)=0.D0
		DESTOT(J)=0.D0	
	ENDDO

	DO I=1,NRBIS2
 
		IR1=REACT(I,1)
		IR2=REACT(I,2)
		IR3=REACT(I,3)
		IPROD1=REACT(I,4)
		IPROD2=REACT(I,5)
		IPROD3=REACT(I,6)
		IPROD4=REACT(I,7)
		
		RATE=K(I)*SN(IR1)*SN(IR2)*SN(IR3)
	
		FORM(IPROD1,I)=RATE
		FORM(IPROD2,I)=RATE
		FORM(IPROD3,I)=RATE
		FORM(IPROD4,I)=RATE
		DEST(IR1,I)=RATE
		DEST(IR2,I)=RATE
		DEST(IR3,I)=RATE
		
		FORMTOT(IPROD1)=FORMTOT(IPROD1)+RATE 
		FORMTOT(IPROD2)=FORMTOT(IPROD2)+RATE
		FORMTOT(IPROD3)=FORMTOT(IPROD3)+RATE 
		FORMTOT(IPROD4)=FORMTOT(IPROD4)+RATE 
		DESTOT(IR1)=DESTOT(IR1)+RATE
		DESTOT(IR2)=DESTOT(IR2)+RATE
		DESTOT(IR3)=DESTOT(IR3)+RATE
		
	ENDDO	

C	put FORM and DEST in the increasing order 
	DO M=1,NS2-1
	DO I=1,NRBIS2
		X(I)=FORM(M,I)
		IY(I)=I
	ENDDO		
	
	CALL SSORT (X, IY, NRBIS3)

	WRITE (11,*) SPEC(M)
	WRITE (11,*) 'REACTIONS OF PRODUTION',FORMTOT(M)
	DO I=1,5
		IF (X(I).NE.0D0) WRITE(11,*)  IY(I), X(I)
	ENDDO

	DO I=1,NRBIS2
		X(I)=DEST(M,I)
		IY(I)=I
	ENDDO		

	CALL SSORT (X, IY, NRBIS3)

	WRITE (11,*) 'REACTIONS OF DESTRUCTION',DESTOT(M)
	DO I=1,5
		IF (X(I).NE.0D0) WRITE(11,*)  IY(I), -X(I)
	ENDDO
	
	ENDDO
	
	RETURN
	END
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C	this subroutine checks that the densities of charged species 
C	and elements are conservative 
	
	SUBROUTINE CHECKING (NS2,ELEMENT,NELEM,SN,IGRAIN0,IGRAINN)
	
	IMPLICIT NONE
	
	INTEGER ELEMENT,NELEM,NS2,I,J,IGRAIN0,IGRAINN
	DOUBLE PRECISION SN,PLUS,MINUS,DPM,CHECK_ELEM
	DIMENSION SN(NS2),ELEMENT(NELEM,NS2),CHECK_ELEM(NELEM-1)

	PLUS=0.D0
	MINUS=0.D0
	
	DO I=1,NELEM-1
		CHECK_ELEM(I)=0.D0
	ENDDO
		
	DO I=1,NS2-1
		IF (ELEMENT(1,I).EQ.1) PLUS=PLUS+SN(I)
		IF (ELEMENT(1,I).EQ.-1) MINUS=MINUS+SN(I)
	ENDDO
		
	DPM=(PLUS-MINUS)/PLUS
	
	WRITE (11,*) '(positive) - (negative)/(positive)',DPM
	WRITE (*,*) '(positive) - (negative)/(positive)',DPM
	write(*,*) 'grains',SN(IGRAIN0)+SN(IGRAINN)
	DO I=1,NELEM-1
		DO J=1,NS2-3
			CHECK_ELEM(I)=CHECK_ELEM(I)+FLOAT(ELEMENT(I+1,J))*SN(J)
		ENDDO
	ENDDO
	
	WRITE(11,*) '( H  He C  N  O  SI S  FE NA MG CL P F)'
	WRITE(11,*) CHECK_ELEM
	WRITE(*,*) '( H  He C  N  O  SI S  FE NA MG CL P F)'
	WRITE(*,*) CHECK_ELEM

	RETURN
	END
	
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	dummy subroutine 
C	this subroutine is needed because we are not supplying 
C	the jacobian matrix 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	SUBROUTINE DUMMY 
	
	ENTRY JAC (NEQ, T, Y, ML, MU, PD, NROWPD)
	
	RETURN
	END
	
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C	subroutine to sort the numbers

      SUBROUTINE SSORT (X, IY, N)
      IMPLICIT NONE
	
c
c    Example of an Insertion Sort
c
C***BEGIN PROLOGUE  SSORT
C***PURPOSE  Sort an array and make the same interchanges in
C            an auxiliary array.  The array is sorted in
C            decreasing order.
C***TYPE      SINGLE PRECISION
C***KEYWORDS  SORT, SORTING
C
C   Description of Parameters
C      X - array of values to be sorted   (usually abscissas)
C      IY - array to be carried with X (all swaps of X elements are
C          matched in IY .  After the sort IY(J) contains the original
C          postition of the value X(J) in the unsorted X array.
C      N - number of values in array X to be sorted
C      KFLAG - Not used in this implementation
C
C***REVISION HISTORY  (YYMMDD)
C   950310  DATE WRITTEN
C   John Mahaffy
C***END PROLOGUE  SSORT
C     .. Scalar Arguments ..
      INTEGER N
C     .. Array Arguments ..
      DOUBLE PRECISION X(*)
      INTEGER IY(*)
C     .. Local Scalars ..
      DOUBLE PRECISION TEMP
      INTEGER I, J, L, ITEMP
C     .. External Subroutines ..
C     None
C     .. Intrinsic Functions ..
C     None
C
C***FIRST EXECUTABLE STATEMENT  SSORT
C
      DO 100 I=2,N
         IF ( X(I).GT.X(I-1) ) THEN
            DO 50 J=I-2,1,-1
              IF(X(I).LT.X(J)) go to 70
  50          CONTINUE
            J=0
  70        TEMP=X(I)
            ITEMP=IY(I)
            DO 90 L=I,J+2,-1
              IY(L)=IY(L-1)
  90          X(L)=X(L-1)
            X(J+1)=TEMP
            IY(J+1)=ITEMP
         ENDIF
  100 CONTINUE
      RETURN
      END

